DEBUG = true

gTimerValue = 0.0
TIMEOUT_1000 = 8.0
gIsExpert = true

function Initialise()
	gIsExpert = Call ( "IsExpertMode" ) ~= 0
    DebugPrint ( ( "DEBUG: Initialise" ) )
	
end

--
-- Called when the timer must decrement
function Update( time )
	gTimerValue = gTimerValue - time
	if ( gTimerValue <= 0.0 ) then
		Call ( "*:SetControlValue", "EmergencyBrake", 0, 1)
	end
end

function OnControlValueChange ( name, index, value )
	Call( "*:SetControlValue", name, index, value );
	if ( name == "AWSReset" and value > 0 ) then
		Call ( "*:SetControlValue", "AWS", 0, 0 )
		Call ( "*:SetControlValue", "AWSWarnCount", 0, 0 )
		Call ( "*:SetControlValue", "EmergencyBrake", 0, 0 )
		Call ( "EndUpdate" )
	end
end

function OnConsistMessage ( message, arg, direction )
	DebugPrint ( ( "DEBUG: OnConsistMessage msg:" .. message .. ", arg:" .. arg .. ", dir" .. direction ) )
end

function OnCustomSignalMessage ( arg )
	DebugPrint ( ( "DEBUG: OnCustomSignalMessage arg:" .. arg ) )
	if ( gIsExpert ) then
		if ( arg == "1000" ) then
			Call ( "*:SetControlValue", "AWS", 0, 1 )
			Call ( "*:SetControlValue", "AWSWarnCount", 0, 1)
			gTimerValue = TIMEOUT_1000
			Call( "BeginUpdate" )
		elseif (arg == "2000" ) then
			Call ( "*:SetControlValue", "AWS", 0, 1 )
			Call ( "*:SetControlValue", "AWSWarnCount", 0, 1)
			Call ( "*:SetControlValue", "EmergencyBrake", 0, 1)
		end
	end
end

function DebugPrint( message )
	if (DEBUG) then
		Print( message )
	end
end

