local isInitialized = false
local timeSpent = 0

local GetControlValue ="*:GetControlValue"
local SetControlValue = "*:SetControlValue"
local AddTime = "*:AddTime"

local Reverser = "Reverser"
local PantographKontrol = "Pantograph_Kontrol"
local PantographControl ="PantographControl"
local PantographControlFront = "Pantograph_Control_Front"
local PantographControlBack = "Pantograph_Control_Back"
local PantoFront = "Panto_Front"
local PantoBack = "Panto_Back"
local MainLine = "MainLine"
local MainSwitch = "Main_Switch"
local Reverser = "Reverser"
local VirtualThrottle = "VirtualThrottle"
local Throttle = "Throttle"
local Speedometer = "SpeedometerKPH"
local Ammeter = "Ammeter"
local AmmeterPonter = "Ammeter_Ponter"
local Regulator = "Regulator"
local Regulator2 = "Regulator2"
local DynamicBrake = "DynamicBrake"

local isFstActiv = false
local pantoFrontActive = 0
local lastPantoFrontValue = 0
local pantoBackActive = 0
local voltageEnabled = false
local lastPantoBackValue = 0
local pantoMovementSpeed = 0.2
local pantoRaiseSpeed = 0.5
local pantoDropSpeed = 0.75

local mainSwitchTurnedOn = false

local reverserPosition = 0

local virtualThrottlePosition = 0.5

local lastCurrent = 0
local currentVoltage = 0

local wheelRadius = 1.145 / 2 -- in meters
local gearRatio = 73 / 29
local R_cu = 0.033 -- reiner Kupferwiderstand vo mtypenschild veruscht nachzubilden
local R_start = 0.089 -- from Typenschild im Nennpunkt
local fieldWeakeningRpm = 1050 -- in rpm, from typenschild
local maxWeakening = 0.75

local maxTableForce = 45 --from TractiveEffortVsSpeed table neutralised so that my torque works
local maxTablePower = 250

local transformatorVolatages = {
	[0] = 0,
	[1] = 30,
	[2] = 60,
	[3] = 70,
	[4] = 80,
	[5] = 100,
	[6] = 120,
	[7] = 140,
	[8] = 160,
	[9] = 180,
	[10] = 200,
	[11] = 220,
	[12] = 240,
	[13] = 260,
	[14] = 280,
	[15] = 300,
	[16] = 320,
	[17] = 340,
	[18] = 360,
	[19] = 380,
	[20] = 400,
	[21] = 420,
	[22] = 440,
	[23] = 460,
	[24] = 480,
	[25] = 500,
	[26] = 520,
	[27] = 530,
	[28] = 540
}

local currentTransformatorStep = 0

local switchTimeDifference = 0

function Initialise()
    Print("[Init] Locomotive script loaded. From OBB4010.lua")
	Call( "BeginUpdate" )
end


function Update (interval)
	timeSpent = timeSpent + interval
	if(lastPantoFrontValue ~= pantoFrontActive or lastPantoBackValue ~= pantoBackActive) then
		RaiseLowerPanto(interval)
	end
	checkPantoState()

	
	SetTractiveEffort(interval)

	CalculateTractiveEffort()
end

function OnControlValueChange(name, index, value)
	if not isInitialized then
		Call(SetControlValue, VirtualThrottle, 0, 0.5)
		Call(SetControlValue, PantographKontrol, 0, 2)
		Call(SetControlValue, Reverser, 0, 0)
		isInitialized = true
	end
			
	if name == PantographKontrol then
		local pantoValue = Call(GetControlValue, PantographKontrol, 0)
		local correctedPantoValue = CorrectPantoPosition(pantoValue)
		setActivePanto(correctedPantoValue)
		
	elseif name == MainSwitch then
		updateMainSwitchState()
	elseif name == Reverser then
		toggleReverser()
	elseif name == VirtualThrottle then
		correctVirtualThrottlePosition()
	end
	
end


-- functional methods --
function CorrectPantoPosition(pantoValue)
		local correctedPantoValue = 0
		if pantoValue >= 0 and pantoValue < 0.5 then
			correctedPantoValue = 0
		elseif pantoValue >= 0.5 and pantoValue < 1.5 then
			correctedPantoValue = 1
		elseif pantoValue >= 1.5 and pantoValue < 2.5 then
			correctedPantoValue = 2
		elseif pantoValue >= 2.5 and pantoValue < 3.5 then
			correctedPantoValue = 3
		elseif pantoValue >= 3.5 then
			correctedPantoValue = 4
		end
		Call(SetControlValue, PantographKontrol, 0, correctedPantoValue)
		isFstActiv = correctedPantoValue ~= 0
		handleFstActivation()
		
		return correctedPantoValue
end

function setActivePanto(correctedPantoValue)
	if correctedPantoValue == 0 then
			Call(SetControlValue, PantographControlFront, 0, 0)
			Call(SetControlValue, PantographControlBack, 0, 1)
			pantoFrontActive = 0
			pantoBackActive = 1
			Print("[Panto Control] Front pantograph active")
		elseif correctedPantoValue == 4 then
			Call(SetControlValue, PantographControlFront, 0, 1)
			Call(SetControlValue, PantographControlBack, 0, 0)
			pantoFrontActive = 1
			pantoBackActive = 0
			
			Print("[Panto Control] Rear pantograph active")
		else
			Call(SetControlValue, PantographControlFront, 0, 0)
			Call(SetControlValue, PantographControlBack, 0, 0)
			pantoFrontActive = 0
			pantoBackActive = 0
			Print("[Panto Control] No pantograph active")
		end
end

function RaiseLowerPanto(interval)
	local delta = 0
	
	if lastPantoBackValue == 0 then
		if lastPantoFrontValue < pantoFrontActive then
			delta = pantoRaiseSpeed * interval
			lastPantoFrontValue = math.min(pantoFrontActive, lastPantoFrontValue + delta)
			Call(AddTime, PantoFront, delta)
	
		elseif lastPantoFrontValue > pantoFrontActive then
			delta = pantoDropSpeed * interval
			lastPantoFrontValue = math.max(pantoFrontActive, lastPantoFrontValue - delta)
			Call(AddTime, PantoFront, -delta)
		end
	end
	
	if lastPantoFrontValue == 0 then
		if lastPantoBackValue < pantoBackActive then
			delta = pantoRaiseSpeed * interval
			lastPantoBackValue = math.min(pantoBackActive, lastPantoBackValue + delta)
			Call(AddTime, PantoBack, delta)
	
		elseif lastPantoBackValue > pantoBackActive then
			delta = pantoDropSpeed * interval
			lastPantoBackValue = math.max(pantoBackActive, lastPantoBackValue - delta)
			Call(AddTime, PantoBack, -delta)
		end
	end
end

function checkPantoState()
 if lastPantoFrontValue == 1 or lastPantoBackValue == 1 then
		Call(SetControlValue, PantographControl, 0, 1)
        Call(SetControlValue, MainLine, 0, 15)
		voltageEnabled = true
		Print("[RaiseLowerPanto] Panto is on, Power is on!")
	elseif lastPantoFrontValue ~= 1 and lastPantoBackValue ~= 1 then
		Call(SetControlValue, PantographControl, 0, 0)
        Call(SetControlValue, MainLine, 0, 0)
		handlePantoLow()
		Print("[RaiseLowerPanto] Panto is off, Power is off!")
	end
end

function updateMainSwitchState()
	local mainswitchValue = Call(GetControlValue, MainSwitch, 0)
	if mainswitchValue <= 0.8 or voltageEnabled == false then
		Call(SetControlValue, MainSwitch, 0, 0)
		mainSwitchTurnedOn = false
	else
		Call(SetControlValue, MainSwitch, 0, 1)
		mainSwitchTurnedOn = true
	end
end

function toggleReverser()
	local reverserValue = Call(GetControlValue, Reverser, 0)
	Print("[ReverserToggle] Reverservalue is: " .. reverserValue)
		if reverserValue < -0.5 then
			reverserPosition = -1
		elseif reverserValue > 0.5 then
			reverserPosition = 1
		else
			reverserPosition = 0
		end
		Call(SetControlValue, Reverser, 0 , reverserPosition)
end

function correctVirtualThrottlePosition()
	local virtualThrottleValue = Call(GetControlValue, VirtualThrottle, 0)
	if virtualThrottleValue <= 0.5 then
		virtualThrottlePosition = virtualThrottleValue
	elseif virtualThrottleValue > 0.5 and virtualThrottleValue <= 0.5465 then
		virtualThrottlePosition = 0.5
	elseif virtualThrottleValue > 0.5465 and virtualThrottleValue <= 0.644 then
		virtualThrottlePosition = 0.593
	elseif virtualThrottleValue > 0.644 and virtualThrottleValue <= 0.75 then
		virtualThrottlePosition = 0.695
	elseif virtualThrottleValue > 0.75 and virtualThrottleValue <= 0.8525 then
		virtualThrottlePosition = 0.805
	elseif virtualThrottleValue > 0.8525 and virtualThrottleValue <= 0.95 then
		virtualThrottlePosition = 0.9
	elseif virtualThrottleValue > 0.95 then
		virtualThrottlePosition = 1
	end

	Call(SetControlValue, VirtualThrottle, 0, virtualThrottlePosition)

	switchTimeDifference = 0
end

function GetMotorFlux(current, fwFactor)
	local maxFlux = 4.2 --precalculated from Typenschild
	local k = 0.0025 --Steigung im linearen Bereich ohne Sättigung
	return (maxFlux * (current * k) /(1 + current * k)) * fwFactor
end

function GetBackEmf(current, omega_rad, fwFactor)
	local uInd = GetMotorFlux(current, fwFactor) * omega_rad
	return uInd
end

function CalculateTorque()
	local currentSpeed = Call(GetControlValue, Speedometer, 0)
	local absoluteSpeed = math.abs(currentSpeed) / 3.6 -- /3.6 for kmh -> m/s, need to calculate motorspeed

	if absoluteSpeed < 0.02 then
		absoluteSpeed = 0
	end
	local omegaMotor = (absoluteSpeed / wheelRadius) * gearRatio -- in rad/s
	
	local motorRpm = GetMotorRpm(omegaMotor)
	local fw = CalculateFieldWeakeningFactor(motorRpm)

	local backEmf = GetBackEmf(lastCurrent, omegaMotor, fw)

	local resistance = CalculateImpedance(omegaMotor)
	local smoothingfactor = 0.1
	local targetcurrent = (currentVoltage - backEmf) / resistance

	local newCurrent = lastCurrent + ((targetcurrent - lastCurrent) * smoothingfactor)

	lastCurrent = newCurrent
	Call(SetControlValue, AmmeterPonter, 0, newCurrent)

	local torque = GetMotorFlux(newCurrent, fw) * newCurrent * gearRatio
	return torque
end

function CalculateImpedance(omega)
	local R_dynamic = R_cu + (R_start - R_cu) * math.exp(-0.5 * omega)
	return R_dynamic
end

function CalculateFieldWeakeningFactor(rpm)
	if(rpm < fieldWeakeningRpm) then
		return 1.0
	else
		local factor = 1.0 - ((rpm - fieldWeakeningRpm) / (1800 - fieldWeakeningRpm)) * (1.0 - maxWeakening)
		return math.max(maxWeakening, factor)
	end 
end

function CalculateTractiveEffort()
	local torque = CalculateTorque()
	local tractiveEffort = (torque / wheelRadius) / 1000

	if tractiveEffort > maxTableForce then
		tractiveEffort = maxTableForce
	end
	
	local virtualThrottle = tractiveEffort / maxTableForce

	if virtualThrottle > 0 and tractiveEffort > 0 then
		displayAlertMessage("VirtualThrottle: " .. virtualThrottle .. " TractiveEffort: " .. tractiveEffort)
	end
	Call(SetControlValue, Regulator, 0, virtualThrottle)
	return tractiveEffort
end

function GetMotorRpm(omegaMotor)
	return (omegaMotor * 60) / (2 * math.pi)
end

function SetTractiveEffort(interval)
	local throttlePosition = Call(GetControlValue, VirtualThrottle, 0)

	if throttlePosition == 0.695 or throttlePosition == 0.5 then
		return
	elseif throttlePosition == 0.593 then
		DecreaseVoltage(interval)
	elseif throttlePosition == 0.805 then
		IncreaseVoltage1(interval)
	elseif throttlePosition == 0.9 then
		IncreaseVoltage2(interval)
	elseif throttlePosition == 1 then
		IncreaseVoltage3(interval)
	end
end

function IncreaseVoltage1(interval)
	switchTimeDifference = switchTimeDifference + interval

	if(switchTimeDifference >= 1 and currentTransformatorStep ~= 28) then
		if((transformatorVolatages[currentTransformatorStep] < 200 and lastCurrent < 1200) or
			transformatorVolatages[currentTransformatorStep] >= 200) then
			currentTransformatorStep = currentTransformatorStep + 1
			currentVoltage = transformatorVolatages[currentTransformatorStep]
		end
		switchTimeDifference = 0
	end
	
	Call(SetControlValue, Regulator2, 0, currentTransformatorStep / 28)
end

function IncreaseVoltage2(interval)
	switchTimeDifference = switchTimeDifference + interval

	if currentTransformatorStep == 28 then
		return
	end

	if lastCurrent < 900 and switchTimeDifference >= 3 then
		currentTransformatorStep = currentTransformatorStep + 1
		currentVoltage = transformatorVolatages[currentTransformatorStep]
		switchTimeDifference = 0
	elseif lastCurrent >= 900 and lastCurrent < 1600 and transformatorVolatages[currentTransformatorStep] < 200
			and switchTimeDifference > 1 then
		currentTransformatorStep = currentTransformatorStep + 1
		currentVoltage = transformatorVolatages[currentTransformatorStep]
		switchTimeDifference = 0
	elseif transformatorVolatages[currentTransformatorStep] > 200 and lastCurrent < 1760
			and switchTimeDifference > 1 then
		currentTransformatorStep = currentTransformatorStep + 1
		currentVoltage = transformatorVolatages[currentTransformatorStep]
		switchTimeDifference = 0
	end
	
	Call(SetControlValue, Regulator2, 0, currentTransformatorStep / 28)
end

function IncreaseVoltage3(interval)
	switchTimeDifference = switchTimeDifference + interval

	if currentTransformatorStep == 28 then
		return
	end

	if lastCurrent < 1200 and switchTimeDifference >= 3 then
		currentTransformatorStep = currentTransformatorStep + 1
		currentVoltage = transformatorVolatages[currentTransformatorStep]
		switchTimeDifference = 0
	elseif lastCurrent >= 1200 and lastCurrent < 2000 and transformatorVolatages[currentTransformatorStep] < 250
			and switchTimeDifference > 1 then
		currentTransformatorStep = currentTransformatorStep + 1
		currentVoltage = transformatorVolatages[currentTransformatorStep]
		switchTimeDifference = 0
	elseif transformatorVolatages[currentTransformatorStep] > 250 and lastCurrent < 2000
			and switchTimeDifference > 1 then
		currentTransformatorStep = currentTransformatorStep + 1
		currentVoltage = transformatorVolatages[currentTransformatorStep]
		switchTimeDifference = 0
	end
	
	Call(SetControlValue, Regulator2, 0, currentTransformatorStep / 28)
end

function DecreaseVoltage(interval)
	switchTimeDifference = switchTimeDifference + interval

	if currentTransformatorStep == 0 then
		return
	end

	if lastCurrent >= 1000 and switchTimeDifference >= 0.3 then
		currentTransformatorStep = currentTransformatorStep - 1
		currentVoltage = transformatorVolatages[currentTransformatorStep]
		switchTimeDifference = 0
	elseif lastCurrent < 1000 and switchTimeDifference >= 0.2 then
		currentTransformatorStep = currentTransformatorStep - 1
		currentVoltage = transformatorVolatages[currentTransformatorStep]
		switchTimeDifference = 0
	end
	
	Call(SetControlValue, Regulator2, 0, currentTransformatorStep / 28)
end

-- event methods --
function handlePantoLow() 
	voltageEnabled = false
	updateMainSwitchState()
end

function handleFstActivation()
end

function displayAlertMessage(message)
	SysCall ("ScenarioManager:ShowAlertMessageExt", "Title Text", message, 10.0 );
end