--------------------------------------------------------------------------------------
-- Engine Script for V200
--
-- (c) Railsimulator.com 2011
-- (c) SeKu 2023
--
-- Provides script for variable exhaust smoke.
--
--------------------------------------------------------------------------------------


-- maximum tractive effort for determining smoke density. Acceleration rate for AI.

MAXTE = 0.5
ACCELRATE = 0.25

gSmokeColourR = 1.0
gSmokeColourG = 1.0
gSmokeColourB = 1.0
gEmitRate = 0.05

-------------------------------------------------------------------------------------
--
-- Require 
--
-------------------------------------------------------------------------------------

require "Assets/Kuju/RailSimulator/RailVehicles/Diesel/V200/default/engine/sifa.out"
Sifa_Initialise = Initialise
Sifa_Update = Update
Sifa_OnControlValueChange = OnControlValueChange
Sifa_OnCustomSignalMessage = OnCustomSignalMessage

function Initialise ()


-- Get emitter values.

	gSmokeColourR, gSmokeColourG, gSmokeColourB = Call( "Exhaust01:GetEmitterColour" )

-- Sifa Initialise aufrufen

	Sifa_Initialise()

-- Stores for checking when values have changed.

	gDriven = 0

	Call( "BeginUpdate" )
	
end

-------------------------------------------------------------------------------------

function OnControlValueChange ( name, index, value )

	Sifa_OnControlValueChange( name, index, value )

	if Call( "*:ControlExists", name, index ) then

		Call( "*:SetControlValue", name, index, value )

	end

end

-------------------------------------------------------------------------------------

function Update ( tick )

-- Sifa Update aufrufen

	Sifa_Update ( tick )

-- Check for player train.

	if Call( "GetIsPlayer" ) == 1 then

-- Check if player is driving this engine.

		if ( Call( "GetIsEngineWithKey" ) == 1 ) then
			if gDriven == 0 then
				gDriven = 1
				Call( "*:SetControlValue", "Active", 0, 1 )
			end
		else
			if gDriven == 1 then
				gDriven = 0
				Call( "*:SetControlValue", "Active", 0, 0 )
			end
		end

-- Get tractive effort values for this vehicle.
		TractiveEffort = Call ( "GetTractiveEffort" )
		TractiveEffort = math.abs ( TractiveEffort )

	else -- This is an AI train.

-- Tractive effort doesn't work for AI, so use acceleration.

		Accel = Call( "GetAcceleration" )
		Speed = Call( "GetSpeed" )

-- Unfortunately acceleration is signed based on direction loco is facing (sic).
		if Speed < 0 then
			Accel = Accel * -1
		end

		if Accel > ACCELRATE then
			TractiveEffort = MAXTE
		elseif ( math.abs(Speed) > 1 ) and ( Accel > -0.1 ) then
			TractiveEffort = MAXTE/2
		else
			TractiveEffort = MAXTE/11
		end

	end


	if TractiveEffort < MAXTE/10 then
						
		gSmokeColourR = 0.8
		gSmokeColourG = 0.8
		gSmokeColourB = 0.8
		Call ( "Exhaust01:SetEmitterColour", gSmokeColourR, gSmokeColourG, gSmokeColourB )
		Call ( "Exhaust02:SetEmitterColour", gSmokeColourR, gSmokeColourG, gSmokeColourB )
		Call ( "Exhaust01:SetEmitterRate", gEmitRate )
		Call ( "Exhaust02:SetEmitterRate", gEmitRate )

	end
				
	if ( TractiveEffort <= MAXTE/2 ) and ( TractiveEffort >= MAXTE/10 ) then
				
		gSmokeColourR = 0.25
		gSmokeColourG = 0.25
		gSmokeColourB = 0.25
		Call ( "Exhaust01:SetEmitterColour", gSmokeColourR, gSmokeColourG, gSmokeColourB )
		Call ( "Exhaust02:SetEmitterColour", gSmokeColourR, gSmokeColourG, gSmokeColourB )
		Call ( "Exhaust01:SetEmitterRate", 0.01 )
		Call ( "Exhaust02:SetEmitterRate", 0.01 )

	end
		
	if TractiveEffort > MAXTE/2 then 
	
		gSmokeColourR = 0.0
		gSmokeColourG = 0.0
		gSmokeColourB = 0.0
		Call ( "Exhaust01:SetEmitterColour", gSmokeColourR, gSmokeColourG, gSmokeColourB )
		Call ( "Exhaust02:SetEmitterColour", gSmokeColourR, gSmokeColourG, gSmokeColourB )
		Call ( "Exhaust01:SetEmitterRate", 0.005 )
		Call ( "Exhaust02:SetEmitterRate", 0.005 )

	end

-- Cab light.
	if Call("GetIsPlayer") == 1 then
		if math.floor(Call("*:GetControlValue", "Cablightcontrol", 0)) == 0 then
			Call( "CablightF:Activate", 0)
			Call( "CablightB:Activate", 0)
		elseif math.floor(Call("*:GetControlValue", "Cablightcontrol", 0)) == 1 then
			Call( "CablightF:Activate", 1)
			Call( "CablightB:Activate", 1)
		end
	end
	if Call("GetIsPlayer") == 0 then
		Call( "CablightF:Activate", 0)
		Call( "CablightB:Activate", 0)
	end

end

function Msg(Domain, Message)
	SysCall("ScenarioManager:ShowAlertMessageExt", Domain, Message, 5, 0)
end

function OnCustomSignalMessage ( arg )
	Sifa_OnCustomSignalMessage ( arg )
end