------------------------------------------------
-- ScenarioScript
------------------------------------------------
--WaggonWerkstatt

-- true/false defn
FALSE = 0
TRUE = 1

-- condition return values
CONDITION_NOT_YET_MET = 0
CONDITION_SUCCEEDED = 1
CONDITION_FAILED = 2

-- Message types
MT_INFO = 0			-- large centre screen pop up
MT_ALERT = 1		-- top right alert message

MSG_TOP = 1
MSG_VCENTRE = 2
MSG_BOTTOM = 4
MSG_LEFT = 8
MSG_CENTRE = 16
MSG_RIGHT = 32

MSG_SMALL = 0
MSG_REG = 1
MSG_LRG = 2

gVideoPlaying = FALSE

--------------------------------------------------------------------------
-- O n   E v e n t
--------------------------------------------------------------------------

function OnEvent ( event )
  
  if (gVideoPlaying == TRUE) then
		gEventOnVideoStop = event
	else
		ExecEvent(event);
	end
   
end  -- OnEvent

--------------------------------------------------------------------------
-- G e n e r i c   E v e n t   H a n d l e r
--------------------------------------------------------------------------

function ExecEvent( event )
	
  if (string.sub(event, 1, 7) == "Message") then
		DisplayRecordedMessage(string.sub(event, 8))
	else
		_G["OnEvent" .. event]()
	end
  
end -- ExecEvent


---------------------------------------------------------------------------
-- S p e c i f i c   E v e n t   H a n d l e r s
---------------------------------------------------------------------------

function OnEventLockControls()
	SysCall ("LockControls")
end

function OnEventUnlockControls()
	SysCall ("UnlockControls")
end

function OnEventCinematic()
	SysCall ("CameraManager:ActivateCamera", "CinematicIntro", 0 );
end

function OnEventCabcam()
	SysCall ("CameraManager:ActivateCamera", "CabCamera", 0 );
end

function OnEventIntro()
	DisplayRecordedMessage("Intro")
end

function OnEventReminder()
	DisplayRecordedMessage("Reminder")
end

function OnEventScnend()
	SysCall ("ScenarioManager:BeginConditionCheck", "ScnCompleted", 0 );
end

---------------------------------------------------------------------------
-- C o n d i t i o n   C h e c k s
---------------------------------------------------------------------------

function TestCondition(condition)
  
  if (condition == "ScnCompleted") then
    DisplayRecordedMessage("ScnEnd")
    -- exit function        
    return CONDITION_SUCCEEDED;
  end
     
  -- exit function
  return CONDITION_NOT_YET_MET;
    
end -- TestCondition

---------------------------------------------------------------------------
-- M e s s a g e   h a n d l e r s
---------------------------------------------------------------------------

function DisplayRecordedMessage( messageName )
	SysCall("RegisterRecordedMessage", "StartDisplay" .. messageName, "StopDisplay" .. messageName, 1);
end

--  Intro Message
function StartDisplayIntro()
	SysCall ( "ScenarioManager:ShowInfoMessageExt", "", "intro.html", 15, MSG_TOP + MSG_RIGHT, MSG_REG, TRUE );
end

function StopDisplayIntro()
end

-- Reminder 
function StartDisplayReminder()
	SysCall ( "ScenarioManager:ShowInfoMessageExt", "", "reminder.html", 15, MSG_TOP + MSG_RIGHT, MSG_SMALL, TRUE );
end

function StopDisplayReminder()
end

--  Scenario end message
function StartDisplayScnEnd()
	SysCall ( "ScenarioManager:ShowInfoMessageExt", "", "scnend.html", 15, MSG_TOP + MSG_RIGHT, MSG_SMALL, TRUE );
end

function StopDisplayScnEnd()
end
