------------------------------------------------
-- Scenario Script - '[426] Commute to Work'
------------------------------------------------

-- true/false defn
FALSE = 0
TRUE = 1

-- condition return values
CONDITION_NOT_YET_MET = 0
CONDITION_SUCCEEDED = 1
CONDITION_FAILED = 2

-- Message types
MT_INFO = 0     	-- large centre screen pop up
MT_ALERT = 1    	-- top right alert message

MSG_TOP = 1
MSG_LEFT = 8
MSG_RIGHT = 32

MSG_SMALL = 0
MSG_REG = 1
MSG_LRG = 2


--***will be Used to reset the camera after looking at an object
local CameraMoved = 0

--***will be Used to count seconds before moving the camera back
speedtimer = 0

-- Flag to determine whether the game should check the speed limit or not
SpeedLimitCheck = true
AlertOnStop = false

LastSpeedLimit = 0.0

--declare a variable for the scenario time
ScenarioTime = 0

ScenarioTimeInterval = 0

--Used to ensure time to go message is only displayed once
SpeedMessageCheck = 0

DisableStopMessage = false

-----------------------------------------------------------------
--EVENT TRIGGERS--
-----------------------------------------------------------------
function OnEvent (event)
	if event == "camera01" then -- intro cinematic
		SysCall ( "PlayerEngine:SetControlValue", "Headlights", 0, 1 );
		SysCall ( "CameraManager:ActivateCamera", "camera01", 0 ); --Sets the intro cut scene camera 1
		SysCall ( "ScenarioManager:LockControls"); --Locks the controls so the HUD disappears
		return TRUE;
	end
	
	if event == "camera02" then -- intro cinematic
		SysCall ( "CameraManager:ActivateCamera", "camera02", 0 ); --Sets the intro cut scene camera 1
		return TRUE;
	end
					
	if event == "start" then
		SysCall ( "CameraManager:ActivateCamera", "CabCamera", 0);	--set the cab camera
		SysCall( "ScenarioManager:ShowInfoMessageExt", "4e082f8e-538d-4b5a-a970-180f9af07d27", "intro.html", 25, MSG_TOP + MSG_TOP, MSG_SMALL, TRUE );
		return TRUE;
	end
	
	if event == "intro2" then
		SysCall( "ScenarioManager:ShowInfoMessageExt", "4e082f8e-538d-4b5a-a970-180f9af07d27", "intro2.html", 25, MSG_TOP + MSG_TOP, MSG_SMALL, TRUE );
		return TRUE;
	end
	
	if event == "unlockcontrols" then
		SysCall ( "ScenarioManager:UnlockControls");	--unlocks the controls displaying the HUD
		return FALSE;
	end
	
	return FALSE
		
end