-------------------------------------------------------------------------------
-- Eisenbahnwerk / Railworks

-------------------------------------------------------------------------------
gUpdate = false
gEmitRate = 0.0

-- INITIALISE
function Initialise ()

	Call( "Pfeife:SetEmitterActive", 0 );
	Call( "Cylinderhahn_RV:SetEmitterActive", 0 );
	Call( "Cylinderhahn_LV:SetEmitterActive", 0 );
	Call( "Cylinderhahn_RH:SetEmitterActive", 0 );
	Call( "Cylinderhahn_LH:SetEmitterActive", 0 );
	Call( "Abdampf_RV:SetEmitterActive", 0 );
	Call( "Abdampf_LV:SetEmitterActive", 0 );
	Call( "Abdampf_RH:SetEmitterActive", 0 );
	Call( "Abdampf_LH:SetEmitterActive", 0 );
	Call( "SVentil_R:SetEmitterActive", 0 );
	Call( "SVentil_L:SetEmitterActive", 0 );
	Call( "Stationary Smoke:GetEmitterRate", 0 );
	gEmitRate = Call( "Main Smoke Stack:GetEmitterRate" );

	-- If player engine then update
	if Call( "GetIsPlayer" ) then
	
		Call( "BeginUpdate" )
		gUpdate = true
		
	end

end

------------------------------------------------------------
-- OnControlValueChange
------------------------------------------------------------
-- Called when a cab control is modified
------------------------------------------------------------
-- Parameters:
--	name	= Name of the control
--	index	= Index of the control
--	value	= Modified control value
------------------------------------------------------------

function OnControlValueChange ( name, index, value )

	if Call( "*:ControlExists", name, index ) then

		Call( "*:SetControlValue", name, index, value );

	end
	
	if name == "Horn" then
	
		if value > 0.01 then
		
			Call( "Pfeife:SetEmitterActive", 1 );
			
		else
		
			Call( "Pfeife:SetEmitterActive", 0 );
			
		end
		
	end
	
	if name == "CylinderCock" then
	
	    if value > 0.01 then
		
			Call( "Cylinderhahn_RV:SetEmitterActive", 1 );
			Call( "Cylinderhahn_LV:SetEmitterActive", 1 );
			Call( "Cylinderhahn_RH:SetEmitterActive", 1 );
			Call( "Cylinderhahn_LH:SetEmitterActive", 1 );
				
		else
				
			Call( "Cylinderhahn_RV:SetEmitterActive", 0 );
			Call( "Cylinderhahn_LV:SetEmitterActive", 0 );
			Call( "Cylinderhahn_RH:SetEmitterActive", 0 );
			Call( "Cylinderhahn_LH:SetEmitterActive", 0 );
				
		end
		
	end
	
	if name == "Regulator" then
	
		if value > 0.01 then
	
			Call( "Abdampf_RV:SetEmitterActive", 1 );
			Call( "Abdampf_LV:SetEmitterActive", 1 );
			Call( "Abdampf_RH:SetEmitterActive", 1 );
			Call( "Abdampf_LH:SetEmitterActive", 1 );
			
		else
	
			Call( "Abdampf_RV:SetEmitterActive", 0 );
			Call( "Abdampf_LV:SetEmitterActive", 0 );
			Call( "Abdampf_RH:SetEmitterActive", 0 );
			Call( "Abdampf_LH:SetEmitterActive", 0 );
		
		end
		
	end
	
	if name == "SafetyValve1" then
	
		if value > 0.01 then
		
			Call( "SVentil_R:SetEmitterActive", 1 );
		
		else
		
			Call( "SVentil_R:SetEmitterActive", 0 );
		
		end
		
	end
	
	if name == "SafetyValve2" then
	
		if value > 0.01 then
		
			Call( "SVentil_L:SetEmitterActive", 1 );
		
		else
		
			Call( "SVentil_L:SetEmitterActive", 0 );
		
		end
		
	end	
	
end
---------------------------------------------
function Update ( time )

-- ******************  "An dieser Stelle dauerhaft die Schornsteinabdeckung verschwinden lassen"
    Call( "ActivateNode", "cap", 0 )
-- ******************  Ende der nderung "An dieser Stelle dauerhaft die Schornsteinabdeckung verschwinden lassen"
-- Beste Gre von BeeKay

	-- dont update if no longer player
	if Call( "GetIsPlayer" ) == false then
	

		Call( "EndUpdate" )
		gUpdate = false
		
	end
	
	speed = Call ( "GetSpeed" )
	if speed < 0.0 then 
		speed = -speed;			
	end
	
	if speed < 0.3 then
	
		Call ( "Stationary Smoke:SetEmitterActive", 1 );
				
		if speed <= 0.1 then
		
			Call ( "Main Smoke Stack:SetEmitterRate", 100000.0 );
			
		end
		
	else
	
		if speed > 0.1 then 
	
			Call ( "Main Smoke Stack:SetEmitterRate", gEmitRate );
		
		end
		
		if speed > 0.3 then
		
			Call ( "Stationary Smoke:SetEmitterActive", 0 );
			
		end
		
	end

end


