--------------------------------------------------------------------------------------
-- PZB 500Hz Inductor
-- (goes 250m before Hp signal)
-- KUJU / Rail Simulator
--------------------------------------------------------------------------------------

-- debugging stuff
DEBUG = false 					-- set to true to turn debugging on

function DebugPrint( message )
	if (DEBUG) then
		Print( message )
	end
end

-- global constants
CLEAR 				= 0
WARNING 			= 1
BLOCKED 			= 2

PZB_1000_MESSAGE	= 11
PZB_2000_MESSAGE	= 12

--------------------------------------------------------------------------------------
-- INITIALISE
--
function Initialise ()
	mDone = 0
end

--------------------------------------------------------------------------------------
-- DETERMINE CONSIST TYPE
-- Determines whether a consist is fast, slow passenger or freight based on its consist type
--
function DetermineConsistType( )

	local consistType = Call( "GetConsistType" )
	
	if consistType < 0
	or consistType > 10 then
		Print(("ERROR: DetermineConsistType: consistType out of range - " .. consistType))
	end

	DebugPrint(("DEBUG: DetermineConsistType: consistType " .. consistType))
	
	if consistType == CONSIST_TYPE_SPECIAL
	or consistType == CONSIST_TYPE_INTERNATIONAL
	or consistType == CONSIST_TYPE_LIGHT_ENGINE
	or consistType == CONSIST_TYPE_EXPRESS_PASSENGER then
	
		consistType = CONSIST_TYPE_FAST_PASSENGER
		
	elseif consistType == CONSIST_TYPE_STOPPING_PASSENGER then
	
		consistType = CONSIST_TYPE_SLOW_PASSENGER
		
	else
	
		consistType = CONSIST_TYPE_FREIGHT
	end

	return consistType
end

--------------------------------------------------------------------------------------
-- ON CONSIST PASS
--
function OnConsistPass ( prevFrontDist, prevBackDist, frontDist, backDist, linkIndex )

	-- if the consist is crossing the inductor now
	if ( frontDist > 0 and backDist < 0 ) or ( frontDist < 0 and backDist > 0 ) then
	
		-- if the consist was previously before siganl then the crossing has just started
		if (prevFrontDist > 0 and prevBackDist > 0) then
			
			if (mDone ~= 1) then
			
				mDone = 1
				
				-- Request state of next signal				
				local nextSignalState = Call( "GetNextSignalState", "", 1, 1, 0 )
				DebugPrint( ("DEBUG: PZB 500Hz OnConsistPass: Crossing started, next signal state is " .. nextSignalState) )

				-- If the signal ahead is blocked
				if (nextSignalState == BLOCKED) then
				
					-- Get consist speed and figure out how fast they should be going
					local consistSpeed = Call ( "GetConsistSpeed" ) * 3.6	-- convert consist speed from m/s to km/h
					local consistType = DetermineConsistType()
					local speedLimit = 40
					
					-- Set speed limit according to train class
					if consistType == CONSIST_TYPE_FAST_PASSENGER then
					
						speedLimit = 65
					
					elseif consistType == CONSIST_TYPE_SLOW_PASSENGER then
					
						speedLimit = 50
						
					elseif consistType == CONSIST_TYPE_FREIGHT then
					
						speedLimit = 40
					
					else
						Print(("ERROR: OnConsistPass - unknown consist type " .. consistType))
					end
					
					DebugPrint( ("DEBUG: PZB 500Hz OnConsistPass: consistSpeed = " .. consistSpeed .. " km/h, speedLimit = " .. speedLimit .. " km/h") )

					-- If the train is going too fast...
					-- NOTE: Give some leeway, as speed is only displayed to nearest 1km/h in guide window
					if consistSpeed > (speedLimit + 1) then

						Call( "SendConsistMessage", PZB_2000_MESSAGE, "overspeed" )
					end
				end
			end
		end
	else
		-- Reset once train has passed
		if (mDone ~= 0) then
			DebugPrint( ("DEBUG: PZB 500Hz OnConsistPass: Crossing finished") )
			mDone = 0
		end
	end
end

--------------------------------------------------------------------------------------
-- ON SIGNAL MESSAGE
--
function OnSignalMessage( message, parameter, direction, linkIndex )

	-- Forward every message unchanged, unless it's from a train straddling our link
	if ( parameter ~= "DoNotForward" ) then
		Call( "SendSignalMessage", message, parameter, -direction, 1, linkIndex )
	end
end

--------------------------------------------------------------------------------------
-- JUNCTION STATE CHANGE
-- Left blank - PZB inductors always only have one link
--
function OnJunctionStateChange( junction_state, parameter, direction, linkIndex )
	
end

