#!BPY

#"""
#Name: 'RailWorks Bigex (.ia)...'
#Blender: 248
#Group: 'Export'
#Tooltip: 'Exports to Rail Works intermediate animation format (.ia)'
#"""
__author__ = ["HenningBR218"]
__url__ = ("www.blender.org", "www.railsimulator.com", "http://www.forum.rail-sim.de/" ,"http://forums.uktrainsim.com/viewforum.php?f=312")
__version__ = "2.1.71 2011-05-06"
__bypdoc__ = """\

Exporter for Rail Works IA format files (model animation)

Writes Rail Works / Simulator IA format files from Blender.

(C)HenningBR218 2008-2011

"""
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software: you can redistribute it and/or modify
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

from sys import version_info

# Check Python version
if version_info[:2] == (2, 5):
  from bigex25 import InitGUI
elif version_info[:2] == (2, 6):
  from bigex26 import InitGUI
else:
  exit('\nError: Only Python versions 2.5 and 2.6 are supported currently!\n')

##### script control values for the default behavior
gFlags = {
'EXPORT_LOG'             :           1 , # 0: no export log
                                         # 1: write logfile '<igs file name>_exp.log'
                                         # Maximum log level depth is 42
'SCREENDUMPLEVEL'        :           1 , # Console/screen log level depth: 
                                         # 0: none, 1: header only, 
                                         # 2: more, 42: all
'LOGFILEDUMPLEVEL'       :          42 , # same for log file logging depth
'DUMP_OBJECT_OFFSET_LIST':           0   # 1: dump igs object address offset table 
                                         # 0: don't do that 
}

if __name__ == '__main__':
  InitGUI(gFlags)
