#!/usr/bin/python

from gi.repository import Gtk, GLib
import cairo


BLAU_AUS     = 0
BLAU_55      = 1
BLAU_70      = 2
BLAU_85      = 3
BLAU_55BLINK = 4
BLAU_70BLINK = 5
BLAU_85BLINK = 6
BLAU_WECHSEL = 7

MAGNET_AUS   = 0
MAGNET_500   = 1
MAGNET_1000  = 2
MAGNET_ZWANG = 3
MAGNET_STOER = 4


class PZBAnzeige(Gtk.DrawingArea):
    def __init__(self):
        super(PZBAnzeige, self).__init__()

        image = cairo.ImageSurface.create_from_png("pzbanzeige.png")
        #self.set_size_request(image.get_width(), image.get_height())
        self.set_size_request(300, 200)

        self.lampen_oben  = [False, False, False]
        self.lampen_unten = [False, False, False]

        self.lampen_ein = {55: False,  70: False,   85: False,
                           40: False, 500: False, 1000: False}

        self.blau_zustand   = BLAU_AUS
        self.magnet_zustand = MAGNET_AUS
        self.blinken_aktiv  = False

        self.connect("draw", self.draw_callback)
        self.cr_raw_image = image

    def set_blau(self, zustand):
        if self.blau_zustand == zustand:
            return

        self.lampen_ein[55] = False
        self.lampen_ein[70] = False
        self.lampen_ein[85] = False
        blinken = False

        if zustand == BLAU_AUS:
            pass
        elif zustand == BLAU_55:
            self.lampen_ein[55] = True
        elif zustand == BLAU_70:
            self.lampen_ein[70] = True
        elif zustand == BLAU_85:
            self.lampen_ein[85] = True
        elif zustand == BLAU_55BLINK:
            self.lampen_ein[55] = True
            blinken = True
        elif zustand == BLAU_70BLINK:
            self.lampen_ein[70] = True
            blinken = True
        elif zustand == BLAU_85BLINK:
            self.lampen_ein[85] = True
            blinken = True
        elif zustand == BLAU_WECHSEL:
            self.lampen_ein[70] = True
            blinken = True
        else:
            zustand = BLAU_AUS

        self.blau_zustand = zustand
        if blinken:
            self._starte_blinken()
        self.queue_draw()

    def set_magnet(self, zustand):
        if self.magnet_zustand == zustand:
            return

        self.lampen_ein[500]  = False
        self.lampen_ein[1000] = False
        blinken = False

        if zustand == MAGNET_AUS:
            pass
        elif zustand == MAGNET_500:
            self.lampen_ein[500] = True
        elif zustand == MAGNET_1000:
            self.lampen_ein[1000] = True
        elif zustand == MAGNET_ZWANG:
            self.lampen_ein[500] = True
            self.lampen_ein[1000] = True
            blinken = True
        elif zustand == MAGNET_STOER:
            self.lampen_ein[1000] = True
            blinken = True
        else:
            zustand = MAGNET_AUS

        self.magnet_zustand = zustand
        if blinken:
            self._starte_blinken()
        self.queue_draw()

    def set_befehl(self, onoff):
        if self.lampen_ein[40] != onoff:
            self.lampen_ein[40] = onoff
            self.queue_draw()

    def _starte_blinken(self):
        if self.blinken_aktiv:
            return

        GLib.timeout_add(500, self._blink_handler)
        self.blinken_aktiv = True

    def _blink_handler(self):
        blinken_blau = True
        blinken_magnet = True

        if self.blau_zustand == BLAU_55BLINK:
            self.lampen_ein[55] = not self.lampen_ein[55]
        elif self.blau_zustand == BLAU_70BLINK:
            self.lampen_ein[70] = not self.lampen_ein[70]
        elif self.blau_zustand == BLAU_85BLINK:
            self.lampen_ein[85] = not self.lampen_ein[85]
        elif self.blau_zustand == BLAU_WECHSEL:
            self.lampen_ein[70] = not self.lampen_ein[70]
            self.lampen_ein[85] = not self.lampen_ein[85]
        else:
            blinken_blau = False

        if self.magnet_zustand == MAGNET_ZWANG:
            self.lampen_ein[500]  = not self.lampen_ein[500]
            self.lampen_ein[1000] = not self.lampen_ein[1000]
        elif self.magnet_zustand == MAGNET_STOER:
            self.lampen_ein[1000] = not self.lampen_ein[1000]
        else:
            blinken_magnet = False

        self.queue_draw()
        self.blinken_aktiv = blinken_blau or blinken_magnet
        return self.blinken_aktiv

    def draw_callback(self, widget, cr):
        width = widget.get_allocated_width()
        height = widget.get_allocated_height()
        imgwidth = self.cr_raw_image.get_width()
        imgheight = self.cr_raw_image.get_height()

        if height * 1.5 < width:
            width = height * 1.5
        else:
            height = width / 1.5

        cr.scale((1.0 * width) / imgwidth, (1.0 * height) / imgheight)
        cr.set_source_surface(self.cr_raw_image)
        cr.paint()

        cr.identity_matrix()
        cr.scale(width / 3.0, height / 2.0)
        cr.set_source_rgba(0.0, 0.0, 0.0, 0.85)

        pos = {55: (0.0, 0.0), 70: (1.0, 0.0), 85: (2.0, 0.0),
                40: (0.0, 1.0), 500: (1.0, 1.0), 1000: (2.0, 1.0)}

        for lampe in self.lampen_ein.keys():
            if not self.lampen_ein[lampe]:
                cr.rectangle(pos[lampe][0], pos[lampe][1], 1.0, 1.0)
                cr.fill()


# Testfenster falls direkt gestartet
if __name__ == "__main__":
    win = Gtk.Window()
    win.set_title("PZB Test")
    win.connect("destroy", Gtk.main_quit)

    anzeige = PZBAnzeige()
    anzeige.set_blau(BLAU_WECHSEL)
    anzeige.set_magnet(MAGNET_500)

    win.add(anzeige)
    win.show_all()
    Gtk.main()
