#!/usr/bin/lua

-- Test Protokoll via stdin/stdout
--
-- I T:<zeit> S:<strecke> ZA:<zugart> SP:<startprogramm>
-- Initialisierung
--   T:(float) Startzeit Simulation in Sekunden (>= 0)
--   S:(float) Startposition in Meter (>= 0)
--   ZA:[OMU]  Zugart
--   SP:[01]   Startprogramm aktiv
--
-- S T:<zeit> S:<strecke> V:<geschw> M:<mag> BT:<tasten>
--   T:(float)       Simulationszeit in Sekunden
--   S:(float)       Position in Meter
--   V:(float)       Geschwindigkeit in km/h
--   M:[0125]        Aktiver Magnet (0 = keiner)
--   BT:[B-][F-][W-] Betaetigte Tasten
--
-- Antworten:
--
-- S LB:<anzblau> LM:<anzmag> L4:<anzbef> AS:<akust> PG:<geschw> UG:<geschw>
--      E1:<strecke> E1R:<strecke> E5:<strecke>
--   LB:(string) Zustand blaue Lampen
--   LM:(string) Zustand Magnetlampen
--   L4:[01]     Lampe "Befehl 40" an/aus
--   AS:[01]     Akustischer Signalgeber an/aus
--   PG:(float)  Aktive Pruefgeschwindigkeit
--   UG:(float)  Aktive Umschaltgeschwindigkeit
--   E1:(float)  Position Ende der 1000 Hz Ueberwachung
--   E1R:(float) Position Ende der restriktiven 1000 Hz Ueberwachung
--   E5:(float)  Position Ende der 500 Hz Ueberwachung


require "freepzb"

local function pdebug(...)
	io.stderr:write(unpack(arg))
	io.stderr:write("\n")
end


local pzb = freepzb.create(0, 0, "O", true)
freepzb.activate_start(pzb, 0)

for cmdline in io.lines() do
	local cmdargs = {}
	local lampen_blau = freepzb.BLAU_AUS
	local lampen_magnet = freepzb.MAGNET_AUS

	cmd = string.sub(cmdline, 1, 2)

	if cmd == "I " then
		cmdargs.zeit    = tonumber(string.match(cmdline, " T:([%d.]+)"))
		cmdargs.strecke = tonumber(string.match(cmdline, " S:([%d.]+)"))
		cmdargs.zugart  = string.match(cmdline, " ZA:([OMU])")
		cmdargs.sprog   = string.match(cmdline, " SP:([01])")

		pzb = freepzb.create(cmdargs.zeit, cmdargs.strecke, cmdargs.zugart)
		if cmdargs.sprog == "1" then
			freepzb.activate_start(pzb, cmdargs.strecke)
		end

	elseif cmd == "S " then
		cmdargs.zeit    = tonumber(string.match(cmdline, " T:([%d.]+)"))
		cmdargs.strecke = tonumber(string.match(cmdline, " S:([%d.]+)"))
		cmdargs.geschw  = tonumber(string.match(cmdline, " V:([%d.]+)"))
		cmdargs.magnet  = tonumber(string.match(cmdline, " M:([125]?0+)"))

		local tastenstring = string.match(cmdline, " BT:([B-][F-][W-])")
		local tasten = {}
		tasten.befehl  = string.sub(tastenstring, 1, 1) == "B"
		tasten.frei    = string.sub(tastenstring, 2, 2) == "F"
		tasten.wachsam = string.sub(tastenstring, 3, 3) == "W"

		freepzb.update(pzb, cmdargs.zeit, cmdargs.strecke, cmdargs.geschw,
				cmdargs.magnet, tasten)

		if pzb.lampen_blau == freepzb.BLAU_AUS then
			lampen_blau = "aus"
		elseif pzb.lampen_blau == freepzb.BLAU_55 then
			lampen_blau = "55"
		elseif pzb.lampen_blau == freepzb.BLAU_70 then
			lampen_blau = "70"
		elseif pzb.lampen_blau == freepzb.BLAU_85 then
			lampen_blau = "85"
		elseif pzb.lampen_blau == freepzb.BLAU_BLINK_55 then
			lampen_blau = "blink55"
		elseif pzb.lampen_blau == freepzb.BLAU_BLINK_70 then
			lampen_blau = "blink70"
		elseif pzb.lampen_blau == freepzb.BLAU_BLINK_85 then
			lampen_blau = "blink85"
		elseif pzb.lampen_blau == freepzb.BLAU_WECHSEL then
			lampen_blau = "wechsel"
		end

		if pzb.lampen_magnet == freepzb.MAGNET_AUS then
			lampen_magnet = "aus"
		elseif pzb.lampen_magnet == freepzb.MAGNET_1000 then
			lampen_magnet = "1000"
		elseif pzb.lampen_magnet == freepzb.MAGNET_500 then
			lampen_magnet = "500"
		elseif pzb.lampen_magnet == freepzb.MAGNET_ZWANG then
			lampen_magnet = "zwang"
		elseif pzb.lampen_magnet == freepzb.MAGNET_STOER then
			lampen_magnet = "stoer"
		end

		io.write("S LB:", lampen_blau, " LM:", lampen_magnet,
			" L4:", pzb.lampe_befehl and 1 or 0,
			" AS:", pzb.akust_signal and 1 or 0,
			" PG:", pzb.aktive_pruef,
			" UG:", pzb.aktive_umschalt,
			" E1:", pzb.ende_1000hz,
			" E1R:", pzb.ende_r1000hz,
			" E5:", pzb.ende_500hz)
		if pzb.zwangsbremsung then
			local grund
			grund, _ = string.gsub(pzb.zwangsbremsung_grund, " ", "_")
			io.write(" ZB:", grund)
		end
		io.write("\n")
		io.flush()
	else
		pdebug("Unknown from master: ", cmdline)
	end
end
