------------------------------------------------
-- ScenarioScript.lua
-- 21/05/2012
-- Copyright 2012 RailSimulator.com ltd
--
-- Scenario Script - 'Snow Way Out - ICE 3 Scenario'
------------------------------------------------

-- true/false defn
FALSE = 0
TRUE = 1

-- condition return values
CONDITION_NOT_YET_MET = 0
CONDITION_SUCCEEDED = 1
CONDITION_FAILED = 2

-- Message types
MT_INFO = 0     	-- large centre screen pop up
MT_ALERT = 1    	-- top right alert message

MSG_TOP = 1
MSG_VCENTRE = 2
MSG_BOTTOM = 4
MSG_LEFT = 8
MSG_CENTRE = 16
MSG_RIGHT = 32

MSG_SMALL = 0
MSG_REG = 1
MSG_LRG = 2

------------------------------------------------
-- Fn OnEvent
-- 		event - name of the event
--	    return - TRUE/FALSE if event handled
function OnEvent (event)

	if event == "SetCabView" then	-- required for this scenario
	
		SysCall("CameraManager:ActivateCamera", "CabCamera", 0);
		
		return TRUE;
	
	end -- if event == "SetCabView"
		if event == "IntroMessage" then	-- required for this scenario
	
		SysCall ( "ScenarioManager:ShowInfoMessageExt", "af7a2b92-ad57-4bdc-88be-eef5f7459b6a", "IntroMessage.html", 10, MSG_VCENTRE, MSG_REG, TRUE );
		return TRUE;
	end -- if event == "IntroMessage"	
			if event == "FireAlarm" then	-- required for this scenario
		
		SysCall ( "PlayerEngine:SetControlValue", "EmergencyBrake", 0, 1 );
		SysCall ( "PlayerEngine:SetControlValue", "PantographControl", 0, 0 );
		SysCall ( "ScenarioManager:LockControls");
		SysCall ( "ScenarioManager:ShowInfoMessageExt", "af7a2b92-ad57-4bdc-88be-eef5f7459b6a", "FireAlarmMessage.html", 10, MSG_VCENTRE, MSG_REG, FALSE );
		
		return TRUE;
	end -- if event == "FireAlarm2"
				if event == "FireAlarm2" then	-- required for this scenario
		
		SysCall ( "ScenarioManager:ShowInfoMessageExt", "af7a2b92-ad57-4bdc-88be-eef5f7459b6a", "FireAlarmMessage2.html", 10, MSG_VCENTRE, MSG_REG, TRUE );
		SysCall ( "ScenarioManager:UnlockControls");
		
		return TRUE;
	end -- if event == "FireAlarm2"
	
	return FALSE;
	
end -- function OnEvent (event)